<?php

namespace Import\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;

/**
 * Interest
 *
 * @ORM\Table(name="delegation_costs")
 * @ORM\Entity()
 *
 * @ExclusionPolicy("all")
 */
class DelegationCost
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="cost_name", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $cost_name;

    /**
     * @var float
     *
     * @ORM\Column(name="cost", type="float")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $cost;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="createAt", type="datetime")
     */
    private $createAt;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set cost_name
     *
     * @param string $costName
     * @return DelegationCost
     */
    public function setCostName($costName)
    {
        $this->cost_name = $costName;
    
        return $this;
    }

    /**
     * Get cost_name
     *
     * @return string 
     */
    public function getCostName()
    {
        return $this->cost_name;
    }

    /**
     * Set cost
     *
     * @param float $cost
     * @return DelegationCost
     */
    public function setCost($cost)
    {
        $this->cost = $cost;
    
        return $this;
    }

    /**
     * Get cost
     *
     * @return float 
     */
    public function getCost()
    {
        return $this->cost;
    }

    /**
     * Set createAt
     *
     * @param \DateTime $createAt
     * @return DelegationCost
     */
    public function setCreateAt($createAt)
    {
        $this->createAt = $createAt;
    
        return $this;
    }

    /**
     * Get createAt
     *
     * @return \DateTime 
     */
    public function getCreateAt()
    {
        return $this->createAt;
    }
}